import { Light } from './shadow';
export declare function init(): void;
export declare const shadowInfo: Partial<Record<FloorIds, Light[]>>;
export declare const backgroundInfo: Partial<Record<FloorIds, Color>>;
export declare const blurInfo: Partial<Record<FloorIds, number>>;
export declare const immersionInfo: Partial<Record<FloorIds, number>>;
export declare function updateShadow(nocache?: boolean): void;
/**
 * 清除某一层的墙壁缓存
 * @param floorId 楼层id
 */
export declare function clearShadowCache(floorId: FloorIds): void;
/**
 * 设置是否不计算墙壁遮挡，对所有灯光有效
 * @param n 目标值
 */
export declare function setCalShadow(n: boolean): void;
