functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a = 
{
    "events": {
        "initGame": function () {
	// 游戏开始前的一些初始化操作

	// 根据flag来对道具进行修改
	if (core.flags.bigKeyIsBox)
		core.material.items.bigKey = {'cls': 'items', 'name': '钥匙盒'};
	// 面前的墙？四周的墙？
	if (core.flags.pickaxeFourDirections)
		core.material.items.pickaxe.text = "可以破坏勇士四周的墙";
	if (core.flags.bombFourDirections)
		core.material.items.bomb.text = "可以炸掉勇士四周的怪物";
	if (core.flags.snowFourDirections)
		core.material.items.bomb.text = "可以将四周的熔岩变成平地";
	if (core.flags.equipment) {
		core.material.items.sword1.cls = 'constants';
		core.material.items.sword2.cls = 'constants';
		core.material.items.sword3.cls = 'constants';
		core.material.items.sword4.cls = 'constants';
		core.material.items.sword5.cls = 'constants';
		core.material.items.shield1.cls = 'constants';
		core.material.items.shield2.cls = 'constants';
		core.material.items.shield3.cls = 'constants';
		core.material.items.shield4.cls = 'constants';
		core.material.items.shield5.cls = 'constants';
	}
},
        "setInitData": function (hard) {
	// 不同难度分别设置初始属性
	if (hard=='Easy') { // 简单难度
		core.setFlag('hard', 1); // 可以用flag:hard来获得当前难度
		// 可以在此设置一些初始福利，比如设置初始生命值可以调用：
		// core.setStatus("hp", 10000);
		// 赠送一把黄钥匙可以调用
		// core.setItem("yellowKey", 1);
	}
	if (hard=='Normal') { // 普通难度
		core.setFlag('hard', 2); // 可以用flag:hard来获得当前难度
	}
	if (hard=='Hard') { // 困难难度
		core.setFlag('hard', 3); // 可以用flag:hard来获得当前难度
	}
	if (hard=='Hell') { // 噩梦难度
		core.setFlag('hard', 4); // 可以用flag:hard来获得当前难度
	}
	core.events.afterLoadData();
	
	
     // 初始化新勇士
     core.plugin.initHero1();
 
	
},
        "win": function (reason) {
	// 游戏获胜事件 
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.removeGlobalAnimate(0,0,true);
		core.clearMap('all'); // 清空全地图
		core.drawText([
			"\t[" + (reason||"恭喜通关") + "]你的分数是${status:hp}。"
		], function () {
			core.events.gameOver(reason||'', replaying);
		})
	});
},
        "lose": function (reason) {
	// 游戏失败事件
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.drawText([
			"\t["+(reason||"结局1")+"]你死了。\n如题。"
		], function () {
			core.events.gameOver(null, replaying);
		});
	})
},
        "afterChangeFloor": function (floorId) {
	// 转换楼层结束的事件
	if (!core.hasFlag("visited_"+floorId)) {
		core.insertAction(core.floors[floorId].firstArrive);
		core.setFlag("visited_"+floorId, true);
	}
},
        "addPoint": function (enemy) {
	// 加点事件
	var point = enemy.point;
	if (!core.flags.enableAddPoint || !core.isset(point) || point<=0) return [];

	// 加点，返回一个choices事件
	return [
		{"type": "choices",
			"choices": [
				{"text": "攻击+"+(1*point), "action": [
					{"type": "setValue", "name": "status:atk", "value": "status:atk+"+(1*point)}
				]},
				{"text": "防御+"+(2*point), "action": [
					{"type": "setValue", "name": "status:def", "value": "status:def+"+(2*point)}
				]},
				{"text": "生命+"+(200*point), "action": [
					{"type": "setValue", "name": "status:hp", "value": "status:hp+"+(200*point)}
				]},
			]
		}
	];
},
        "afterBattle": function (enemyId,x,y,callback) {
	// 战斗结束后触发的事件

	var enemy = core.material.enemys[enemyId];

	var damage = core.enemys.getDamage(enemyId);
	if (damage == null) damage = core.status.hero.hp+1;

	// 扣减体力值
	core.status.hero.hp -= damage;

	// 记录
	core.status.hero.statistics.battleDamage += damage;

	if (core.status.hero.hp<=0) {
		core.status.hero.hp=0;
		core.updateStatusBar();
		core.events.lose('战斗失败');
		return;
	}
	// 获得金币和经验
	var money = enemy.money;
	if (core.hasItem('coin')) money *= 2;
	if (core.hasFlag('curse')) money=0;
	core.status.hero.money += money;
	var experience =enemy.experience;
	if (core.hasFlag('curse')) experience=0;
	core.status.hero.experience += experience;
	var hint = "打败 " + enemy.name;
	if (core.flags.enableMoney)
		hint += "，金币+" + money;
	if (core.flags.enableExperience)
		hint += "，经验+" + experience;
	core.drawTip(hint);

	// 删除该块
	if (core.isset(x) && core.isset(y)) {
		core.removeBlock(x, y);
		core.canvas.event.clearRect(32 * x, 32 * y, 32, 32);
	}

	// 毒衰咒的处理
	var special = enemy.special;
	// 中毒
	if (core.enemys.hasSpecial(special, 12) && !core.hasFlag('poison')) {
		core.setFlag('poison', true);
	}
	// 衰弱
	if (core.enemys.hasSpecial(special, 13) && !core.hasFlag('weak')) {
		core.setFlag('weak', true);
		var weakValue = core.values.weakValue;
		var weakAtk = weakValue>=1?weakValue:Math.floor(weakValue*core.status.hero.atk);
		var weakDef = weakValue>=1?weakValue:Math.floor(weakValue*core.status.hero.def);
		core.setFlag('weakAtk', weakAtk);
		core.setFlag('weakDef', weakDef);
		core.status.hero.atk-=weakAtk;
		core.status.hero.def-=weakDef;
	}
	// 诅咒
	if (core.enemys.hasSpecial(special, 14) && !core.hasFlag('curse')) {
		core.setFlag('curse', true);
	}
	// 仇恨属性：减半
	if (core.flags.hatredDecrease && core.enemys.hasSpecial(special, 17)) {
		core.setFlag('hatred', parseInt(core.getFlag('hatred', 0)/2));
	}
	// 自爆
	if (core.enemys.hasSpecial(special, 19)) {
		core.status.hero.hp = 1;
	}
	// 退化
	if (core.enemys.hasSpecial(special, 21)) {
		core.status.hero.atk -= (enemy.atkValue||0);
		core.status.hero.def -= (enemy.defValue||0);
		if (core.status.hero.atk<0) core.status.hero.atk=0;
		if (core.status.hero.def<0) core.status.hero.def=0;
	}
	// 增加仇恨值
	core.setFlag('hatred', core.getFlag('hatred',0)+core.values.hatred);
	core.updateStatusBar();


	// 事件的处理
	var todo = [];
	// 如果不为阻击，且该点存在，且有事件
	if (!core.enemys.hasSpecial(special, 18) && core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterBattle[x+","+y];
		if (core.isset(event)) {
			// 插入事件
			core.unshift(todo, event);
		}
	}
	core.unshift(todo, core.plugin.killEnemy());
	// 如果有加点
	var point = core.material.enemys[enemyId].point;
	if (core.isset(point) && point>0) {
		core.unshift(todo, core.events.addPoint(core.material.enemys[enemyId]));
	}

	// 如果事件不为空，将其插入
	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	// 如果已有事件正在处理中
	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();

},
        "afterOpenDoor": function (doorId,x,y,callback) {
	// 开一个门后触发的事件
	
	var todo = [];
	if (core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterOpenDoor[x+","+y];
		if (core.isset(event)) {
			core.unshift(todo, event);
		}
	}

	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();
},
        "afterChangeLight": function (x,y) {
	// 改变亮灯之后，可以触发的事件

},
        "afterPushBox": function () {
	// 推箱子后的事件

	var noBoxLeft = function () {
		// 地图上是否还存在未推到的箱子，如果不存在则返回true，存在则返回false
		for (var i=0;i<core.status.thisMap.blocks.length;i++) {
			var block=core.status.thisMap.blocks[i];
			if (core.isset(block.event) && block.event.id=='box') return false;
		}
		return true;
	}

	if (noBoxLeft()) {
		// 可以通过if语句来进行开门操作
		/*
		if (core.status.floorId=='xxx') { // 在某个楼层
			core.insertAction([ // 插入一条事件
				{"type": "openDoor", "loc": [x,y]} // 开门
			])
		}
		*/
	}
},
        "afterUseBomb": function () {
	// 使用炸弹/圣锤后的事件

	// 这是一个使用炸弹也能开门的例子
	/*
	if (core.status.floorId=='xxx' && core.terrainExists(x0,y0,'specialDoor') // 某个楼层，该机关门存在
		&& !core.enemyExists(x1,y1) && !core.enemyExists(x2,y2)) // 且守门的怪物都不存在
	{
		core.insertAction([ // 插入事件
			{"type": "openDoor", "loc": [x0,y0]} // 开门
		])
	}
	*/

},
        "beforeSaveData": function (data) {
	// 即将存档前可以执行的操作

},
        "afterLoadData": function (data) {
	// 读档事件后，载入事件前，可以执行的操作
	// 可以在这里对怪物数据进行动态修改，详见文档——事件——怪物数据的动态修改


}
    },
    "ui": {
        "drawAbout": function () {
	// 绘制“关于”界面
	if (!core.isPlaying()) {
		core.status.event = {'id': null, 'data': null};
		core.dom.startPanel.style.display = 'none';
	}
	core.lockControl();
	core.status.event.id = 'about';

	core.clearMap('ui', 0, 0, 416, 416);
	var left = 48, top = 36, right = 416 - 2 * left, bottom = 416 - 2 * top;

	core.setAlpha('ui', 0.85);
	core.fillRect('ui', left, top, right, bottom, '#000000');
	core.setAlpha('ui', 1);
	core.strokeRect('ui', left - 1, top - 1, right + 1, bottom + 1, '#FFFFFF', 2);

	var text_start = left + 24;

	// 名称
	core.canvas.ui.textAlign = "left";
	core.fillText('ui', "HTML5 魔塔样板", text_start, top+35, "#FFD700", "bold 22px Verdana");
	core.fillText('ui', "版本： "+core.firstData.version, text_start, top + 80, "#FFFFFF", "bold 17px Verdana");
	core.fillText('ui', "作者： 艾之葵", text_start, top + 112);
	core.fillText('ui', 'HTML5魔塔交流群：539113091', text_start, top+112+32);
	// TODO: 写自己的“关于”页面，每次增加32像素即可
}
    },
    "plugins": {
        "plugin": function () {
	////// 插件编写，可以在这里写自己额外需要执行的脚本 //////

	// 在这里写的代码，在所有模块加载完毕后，游戏开始前会被执行
	console.log("插件编写测试");
	// 可以写一些其他的被直接执行的代码


	// 在这里写所有需要自定义的函数
	// 写法必须是 this.xxx = function (args) { ...
	// 如果不写this的话，函数将无法被外部所访问
	this.killEnemy = function () {
    if (core.status.floorId == 'MT4')
 {
        return [ {"type": "setValue", "name": "flag:boss", "value": "flag:boss+1"},
  {"type": "if", "condition": "flag:boss==26",
  "true": [
    "阵法已经破了。。",
    "接下来，要挑战巫妖王了。",
    {"type": "changeFloor", "floorId": "MT5", "loc": [6, 11] },
  ],
  "false": [

  ]
  },
				
        ];
    }
}


	
	this.use1 = function() {
core.insertAction(["使用技能《亡灵出窍》",
  {"type": "setValue", "name": "flag:h1", "value": "Math.floor(status:hp*0.75)"},
  {"type": "function", "function": "function(){\ncore.plugin.changeHero(0)\n}"},
  {"type": "function", "function": "function(){\ncore.resetMap('MT0')\n}"},
  {"type": "setValue", "name": "status:hp", "value": "status:hp+flag:h1"},
  {"type": "changeFloor", "floorId": "MT2", "loc": [6, 12] },
]


)
}
	this.use2 = function() {
core.insertAction([
  {"type": "if", "condition": "flag:0==1",
  "true": [
    {"type": "if", "condition": "main.replayChecking",
    "true": [
      {"type": "changeFloor", "floorId": "MT3", "loc": [6, 12] },
    ],
    "false": [
      "禁咒《元素绽放》",
      {"type": "pauseBgm"},
      {"type": "showGif", "name": "2.gif", "loc": [0,0]},
      {"type": "playSound", "name": "2.mp3"},
      {"type": "sleep", "time": 4500},
      {"type": "showGif"},
      {"type": "showGif", "name": "3.gif", "loc": [0,0]},
      {"type": "sleep", "time": 6000},
      {"type": "setFg", "color": [0,0,0,1], "time": 500},
      {"type": "showGif"},
      "哼！一群蝼蚁！",
      {"type": "changeFloor", "floorId": "MT3", "loc": [6, 12] },
      {"type": "setFg", "time": 500},
      {"type": "playBgm", "name": "bgm.ogg"},
    ]
    },
  ],
  "false": [
    "哼！还不是使用禁咒的时候！",
  ]
  },
]

)
}

	this.use = function() {
core.insertAction([
  {"type": "if", "condition": "main.replayChecking",
  "true": [
    {"type": "changeFloor", "floorId": "MT0", "loc": [6, 12] },
  ],
  "false": [
    "使用技能《亡灵召唤》",
    {"type": "changeFloor", "floorId": "MT0", "loc": [6, 12] },
    {"type": "showGif", "name": "1.gif", "loc": [0,0]},
    {"type": "playSound", "name": "1.mp3"},
    {"type": "sleep", "time": 10000},
    {"type": "showGif"},
    {"type": "showImage", "name": "14.png", "loc": [0,0]},
  ]
  },
  {"type": "while", "condition": "1",
  "data": [
    {"type": "wait"},
    {"type": "if", "condition": "flag:type==1 && flag:x==2 &&  flag:y==1",
    "true": [
      {"type": "if", "condition": "flag:aa==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=48||status:def>=30",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(13)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[2,1]], "time": 500},
          {"type": "changePos", "loc": [2,1], "direction": "down"},
          {"type": "setValue", "name": "flag:aa", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==12 &&  flag:y==3",
    "true": [
      {"type": "if", "condition": "flag:1==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=48||status:def>=30",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(14)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[12,3]], "time": 500},
          {"type": "changePos", "loc": [12,3], "direction": "down"},
          {"type": "setValue", "name": "flag:1", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [

        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==12 &&  flag:y==5",
    "true": [
      {"type": "if", "condition": "flag:2==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=48||status:def>=30",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(15)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[12,5]], "time": 500},
          {"type": "changePos", "loc": [12,5], "direction": "down"},
          {"type": "setValue", "name": "flag:2", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==0 &&  flag:y==10",
    "true": [
      {"type": "if", "condition": "flag:3==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=48||status:def>=30",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(16)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[0,10]], "time": 500},
          {"type": "changePos", "loc": [0,10], "direction": "down"},
          {"type": "setValue", "name": "flag:3", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==2 &&  flag:y==3",
    "true": [
      {"type": "if", "condition": "flag:4==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(1)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[2,3]], "time": 500},
          {"type": "changePos", "loc": [2,3], "direction": "down"},
          {"type": "setValue", "name": "flag:4", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==1 &&  flag:y==5",
    "true": [
      {"type": "if", "condition": "flag:5==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(2)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[1,5]], "time": 500},
          {"type": "changePos", "loc": [1,5], "direction": "down"},
          {"type": "setValue", "name": "flag:5", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==6 &&  flag:y==8",
    "true": [
      {"type": "if", "condition": "flag:6==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(3)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[6,8]], "time": 500},
          {"type": "changePos", "loc": [6,8], "direction": "down"},
          {"type": "setValue", "name": "flag:6", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==9 &&  flag:y==9",
    "true": [
      {"type": "if", "condition": "flag:7==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(4)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[9,9]], "time": 500},
          {"type": "changePos", "loc": [9,9], "direction": "down"},
          {"type": "setValue", "name": "flag:7", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==10 &&  flag:y==12",
    "true": [
      {"type": "if", "condition": "flag:8==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(5)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[10,12]], "time": 500},
          {"type": "changePos", "loc": [10,12], "direction": "down"},
          {"type": "setValue", "name": "flag:8", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==1 &&  flag:y==8",
    "true": [
      {"type": "if", "condition": "flag:9==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=38||status:def>=20",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(8)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[1,8]], "time": 500},
          {"type": "changePos", "loc": [1,8], "direction": "down"},
          {"type": "setValue", "name": "flag:9", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==2 &&  flag:y==10",
    "true": [
      {"type": "if", "condition": "flag:10==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=38||status:def>=20",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(9)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[2,10]], "time": 500},
          {"type": "changePos", "loc": [2,10], "direction": "down"},
          {"type": "setValue", "name": "flag:10", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==4 &&  flag:y==12",
    "true": [
      {"type": "if", "condition": "flag:11==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=38||status:def>=20",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(10)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[4,12]], "time": 500},
          {"type": "changePos", "loc": [4,12], "direction": "down"},
          {"type": "setValue", "name": "flag:11", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==8 &&  flag:y==10",
    "true": [
      {"type": "if", "condition": "flag:12==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=38||status:def>=20",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(11)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[8,10]], "time": 500},
          {"type": "changePos", "loc": [8,10], "direction": "down"},
          {"type": "setValue", "name": "flag:12", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==10 &&  flag:y==4",
    "true": [
      {"type": "if", "condition": "flag:13==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=38||status:def>=20",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(12)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[10,4]], "time": 500},
          {"type": "changePos", "loc": [10,4], "direction": "down"},
          {"type": "setValue", "name": "flag:13", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==0 &&  flag:y==3",
    "true": [
      {"type": "if", "condition": "flag:14==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=10",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(17)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[0,3]], "time": 500},
          {"type": "changePos", "loc": [0,3], "direction": "down"},
          {"type": "setValue", "name": "flag:14", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==4 &&  flag:y==3",
    "true": [
      {"type": "if", "condition": "flag:15==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=10",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(18)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[4,3]], "time": 500},
          {"type": "changePos", "loc": [4,3], "direction": "down"},
          {"type": "setValue", "name": "flag:15", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==6 &&  flag:y==6",
    "true": [
      {"type": "if", "condition": "flag:16==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=10",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(19)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[6,6]], "time": 500},
          {"type": "changePos", "loc": [6,6], "direction": "down"},
          {"type": "setValue", "name": "flag:16", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==9 &&  flag:y==7",
    "true": [
      {"type": "if", "condition": "flag:17==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=10",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(20)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[9,7]], "time": 500},
          {"type": "changePos", "loc": [9,7], "direction": "down"},
          {"type": "setValue", "name": "flag:17", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==11 &&  flag:y==9",
    "true": [
      {"type": "if", "condition": "flag:18==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=34||status:def>=17",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(21)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[11,9]], "time": 500},
          {"type": "changePos", "loc": [11,9], "direction": "down"},
          {"type": "setValue", "name": "flag:18", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==11 &&  flag:y==11",
    "true": [
      {"type": "if", "condition": "flag:19==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=34||status:def>=17",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(22)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[11,11]], "time": 500},
          {"type": "changePos", "loc": [11,11], "direction": "down"},
          {"type": "setValue", "name": "flag:19", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==4 &&  flag:y==1",
    "true": [
      {"type": "if", "condition": "flag:20==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=24",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(6)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[4,1]], "time": 500},
          {"type": "changePos", "loc": [4,1], "direction": "down"},
          {"type": "setValue", "name": "flag:20", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==4 &&  flag:y==7",
    "true": [
      {"type": "if", "condition": "flag:21==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=32||status:def>=24",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(7)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[4,7]], "time": 500},
          {"type": "changePos", "loc": [4,7], "direction": "down"},
          {"type": "setValue", "name": "flag:21", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
    {"type": "if", "condition": "flag:type==1 && flag:x==2 &&  flag:y==0",
    "true": [
      {"type": "if", "condition": "flag:22==1",
      "true": [
        "已经召唤过该怪物！召唤失败！精神力反噬而死！",
        {"type": "lose", "reason": ""},
      ],
      "false": [
        {"type": "if", "condition": "status:atk>=30||status:def>=15",
        "true": [
          {"type": "function", "function": "function(){\ncore.plugin.changeHero(23)\n}"},
          {"type": "showImage"},
          {"type": "hide", "loc": [[2,0]], "time": 500},
          {"type": "changePos", "loc": [2,0], "direction": "down"},
          {"type": "setValue", "name": "flag:22", "value": "1"},
          {"type": "setValue", "name": "item:I306", "value": "1"},
          {"type": "break"},
        ],
        "false": [
          "精神力不足，被怪物反噬而死！",
          {"type": "lose", "reason": ""},
        ]
        },
      ]
      },
    ],
    "false": [

    ]
    },
  ],
  },
]



)
}
	this.test  = function () {
		console.log("插件函数执行测试");
	}

	var _useEquipment = function (itemId, name, type) { // 具体的装备使用效果
		if (itemId.indexOf(name)==0) {
			var now=core.getFlag(name, name+"0");

			if (typeof core.values[now] == 'number') {
				core.status.hero[type] -= core.values[now];
			}
			else {
				core.status.hero.atk -= core.values[now].atk || 0;
				core.status.hero.def -= core.values[now].def || 0;
				core.status.hero.mdef -= core.values[now].mdef || 0;
			}

			if (typeof core.values[itemId] == 'number') {
				core.status.hero[type] += core.values[itemId];
			}
			else {
				core.status.hero.atk += core.values[itemId].atk || 0;
				core.status.hero.def += core.values[itemId].def || 0;
				core.status.hero.mdef += core.values[itemId].mdef || 0;
			}

			core.setItem(now, 1);
			core.setItem(itemId, 0);
			core.setFlag(name, itemId);
			core.drawTip("已装备"+core.material.items[itemId].name);
		}
	}

	this.useEquipment = function (itemId) { // 使用装备
		_useEquipment(itemId, "sword", "atk");
		_useEquipment(itemId, "shield", "def");
	}
	
	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
 // 所有需要保存的内容；这些保存的内容不会多角色共用，在切换时会进行恢复。
 // 你也可以自行新增或删除，比如不共用金币则可以加上"money"的初始化，不共用道具则可以加上"items"的初始化，
 // 多角色共用hp的话则删除hp，等等。总之，不共用的属性都在这里进行定义就好。
 var hero1 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
  var hero2 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
   var hero3 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
 var hero4 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
  var hero5 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
   var hero6= { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero2.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 70,
     "atk": 32,
     "def": 24,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
    var hero7 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero2.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 70,
     "atk": 32,
     "def": 24,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
	 var hero8 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero6.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 200,
     "atk": 38,
     "def": 20,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
	  var hero9 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero6.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 200,
     "atk": 38,
     "def": 20,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
	   var hero10 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero6.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 200,
     "atk": 38,
     "def": 20,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
	    var hero11 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero6.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 200,
     "atk": 38,
     "def": 20,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
		 var hero12 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero6.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 200,
     "atk": 38,
     "def": 20,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
		  var hero13 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero5.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 260,
     "atk": 44,
     "def": 22,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
		   var hero14 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero5.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 260,
     "atk": 44,
     "def": 22,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
		    var hero15 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero5.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 260,
     "atk": 44,
     "def": 22,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
			 var hero16 = { // 1号勇士（默认的是0号）
    "floorId": "MT0", // 该角色楼层ID
     "icon": "hero5.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 260,
     "atk": 44,
     "def": 22,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
			  var hero17 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero7.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 140,
     "atk": 36,
     "def": 10,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
			   var hero18 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero7.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 140,
     "atk": 36,
     "def": 10,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
			    var hero19 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero7.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 140,
     "atk": 36,
     "def": 10,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
				 var hero20= { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero7.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 140,
     "atk": 36,
     "def": 10,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
				  var hero21 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero4.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 100,
     "atk": 34,
     "def": 17,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }

				   var hero22 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero4.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 100,
     "atk": 34,
     "def": 17,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
				   
				   var hero23 = { // 1号勇士（默认的是0号）
     "floorId": "MT0", // 该角色楼层ID
     "icon": "hero1.png", // 角色的行走图名称
     "name": "1号角色",
     "lv": 1,
     "hp": 120,
     "atk": 30,
     "def": 15,
     "mdef": 0,
     "loc": {"x": 0, "y": 0, "direction": "up"},
     // 不共用的数据都可以在这里加上定义
 }
 // 初始化该勇士
 this.initHero1 = function () {
     core.status.hero.icon = "hero.png";
     core.setFlag("hero1", core.clone(hero1));
	  core.setFlag("hero2", core.clone(hero2)); 
	  core.setFlag("hero3", core.clone(hero3));
	 core.setFlag("hero4", core.clone(hero4));
	 core.setFlag("hero5", core.clone(hero5));
	 core.setFlag("hero6", core.clone(hero6));
	 core.setFlag("hero7", core.clone(hero7));
	 core.setFlag("hero8", core.clone(hero8));
	 core.setFlag("hero9", core.clone(hero9));
	 core.setFlag("hero10", core.clone(hero10));
	 core.setFlag("hero11", core.clone(hero11));
	 core.setFlag("hero12", core.clone(hero12));
	 core.setFlag("hero13", core.clone(hero13));
	 core.setFlag("hero14", core.clone(hero14));
	 core.setFlag("hero15", core.clone(hero15));
	 core.setFlag("hero16", core.clone(hero16));
	 core.setFlag("hero17", core.clone(hero17));
	 core.setFlag("hero18", core.clone(hero18));
	 core.setFlag("hero19", core.clone(hero19));
	 core.setFlag("hero20", core.clone(hero20));
	 core.setFlag("hero21", core.clone(hero21));
	 core.setFlag("hero22", core.clone(hero22));
	 core.setFlag("hero23", core.clone(hero23));// 将属性值存到变量中
 }

 // 切换勇士
 this.changeHero = function (toHeroId) {

     var saveList = Object.keys(hero1);

     // 保存当前内容
     var toSave = {};
     saveList.forEach(function(name) {
         if (name=='floorId') toSave[name] = core.status.floorId; // 楼层单独设置
         else toSave[name] = core.clone(core.status.hero[name]); // 使用core.clone()来创建新对象
     })

     var currHeroId = core.getFlag("heroId", 0); // 获得当前角色ID
    

     core.setFlag("hero"+currHeroId, toSave); // 将当前角色信息进行保存

     var data = core.getFlag("hero"+toHeroId); // 获得要切换的角色保存内容

     // 设置角色的属性值
     saveList.forEach(function(name) {
         if (name != 'floorId')
             core.status.hero[name] = core.clone(data[name]);
     })

     // 插入事件：改变角色行走图并进行楼层切换
     core.insertAction([
         {"type": "setHeroIcon", "name": data.icon||"hero.png"}, // 改变行走图
         {"type": "changeFloor", "floorId": data.floorId, "loc": [data.loc.x, data.loc.y], 
             "direction": data.loc.direction, "time": 0} // 楼层切换事件
     ])
     core.setFlag("heroId", toHeroId); // 保存切换到的角色ID
 }
}
    }
}