var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);


	this.drawItemShop = function () {
		// 绘制道具商店
		core.playSound('mouse_click.mp3');

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 1 });
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 480, 480, 'black');
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 0, width: 480, height: 64 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 64, width: 360, height: 64 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 128, width: 360, height: 352 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 360, y: 64, width: 120, height: 64 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 360, y: 128, width: 120, height: 352 });
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 84, 'white', bigFont);
		core.fillText("uievent", "卖出", 152, 84);
		core.fillText("uievent", "离开", 272, 84);
		core.fillText("uievent", "当前生物质", 374, 75, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero.money), 466, 100);
		core.setTextAlign("uievent", "left");
		core.ui._uievent_drawSelector({
			"type": "drawSelector",
			"image": "winskin.png",
			"code": 2,
			"x": 22 + 120 * type,
			"y": 76,
			"width": 60,
			"height": 33
		});
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 420, 360, null, bigFont);
			core.fillText("uievent", "<   " + selectCount + "   >", 420, 390); //core.fillText("uievent", "◀   " + selectCount + "   ▶", 420, 390);
			core.fillText("uievent", "确定", 420, 420);
		}

		// Step 2：获得列表并展示
		var choices = core.status.shops[shopId].choices;
		list = choices.filter(function (one) {
			if (one.condition != null) {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
		});
		var per_page = 7;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 180;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 450, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 450);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 450);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 141 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 148 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + "生物质", 340, 149 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				var text = core.material.items[item.id].text || "该道具暂无描述";
				try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 15; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 467, lineHeight: 1.4 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 60) {
						config.top = (64 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui._uievent_drawSelector({ "type": "drawSelector", "image": "winskin.png", "code": 1, "x": 8, "y": 137 + i * 40, "width": 343, "height": 40 });
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 370, 152, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 470, 152, null, null, 60);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 370, 152, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 470, 152, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计金额", 370, 280);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 470, 310);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 370, 190);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 470, 220);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero.money / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero.money -= totalMoney;
			core.getItem(item.id, selectCount);
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero.money += totalMoney;
			core.removeItem(item.id, selectCount);
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			core.playSound('mouse_click.mp3');
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 81 && py <= 112) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 142 && px <= 202 && py >= 81 && py <= 112) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 262 && px <= 322 && py >= 81 && py <= 112) // 离开
		{
			core.playSound('mouse_click.mp3');
			return core.insertAction({ "type": "break" });
		}
		// ◀，▶
		if (px >= 370 && px <= 395 && py >= 392 && py <= 415)
			return _add(item, -1);
		if (px >= 445 && px <= 470 && py >= 302 && py <= 415)
			return _add(item, 1);
		// 确定
		if (px >= 392 && px <= 443 && py >= 421 && py <= 446)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 70 && px <= 130 && py >= 450) {
			if (page > 1) selectItem -= 7
			return;
		}
		if (px >= 230 && px <= 290 && py >= 450) {
			if (page < totalPage) selectItem = Math.min(selectItem + 7, list.length - 1);
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 351 && py >= 142 && py < 422) {
			if (list.length == 0) return;
			var index = parseInt((py - 142) / 40);
			var newItem = 7 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this.performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{
				"type": "function",
				"function": "function () { " +
					"core.deleteCanvas('uievent'); " +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}"
			}
		]);
	}

	// Write item number to save
	core.control.saveData = function () {
		var data = this.controldata.saveData();
		for (var shopId in core.status.shops) {
			if (core.status.shops[shopId].item) {
				data.shops[shopId].choices = core.status.shops[shopId].choices.map(function (t) {
					return {
						number: t.number,
						money_count: t.money_count || 0,
						sell_count: t.sell_count || 0
					}
				});
			}
		}
		return data;
	}

	core.control.loadData = function (data, callback) {
		this.controldata.loadData(data, callback);
		for (var shopId in data.shops) {
			if (data.shops[shopId].choices) {
				for (var i = 0; i < data.shops[shopId].choices.length; ++i) {
					core.status.shops[shopId].choices[i].number = data.shops[shopId].choices[i].number;
					core.status.shops[shopId].choices[i].money_count = data.shops[shopId].choices[i].money_count;
					core.status.shops[shopId].choices[i].sell_count = data.shops[shopId].choices[i].sell_count;
				}
			}
		}
	}

},
    "smoothCamera": function () {

    // 是否启用本插件，默认不启用
	this.__enableSmoothCamera = false;
	if (!this.__enableSmoothCamera) return;

	this.Camera = function () {

		// 下面这个变量决定本插件的开关
		// 你可以在游戏中使用core.setFlag('smoothCamera',false)来关闭本插件的功能
		// 同时也可以core.setFlag('smoothCamera',true)重新开启
		// 此项默认为true
		// 
		this.__switchName = 'smoothCamera';

		// 初始化成员变量
		this._cameraNeedRefresh = true;
		this._nowOffsetX = 0;
		this._nowOffsetY = 0;
		this._targetOffsetX = 0;
		this._targetOffsetY = 0;
		this._currentFloorId = null;

		// 重置镜头，在楼层变更时使用
		this.resetCamera = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
			this._nowOffsetX = this._targetOffsetX;
			this._nowOffsetY = this._targetOffsetY;
			this._cameraNeedRefresh = true;
		};

		// 设置焦点坐标，目前没有用
		this.setTarget = function (x, y) {
			this._targetOffsetX = x;
			this._targetOffsetY = y;
		};

		// 请求镜头更新
		this.requestCameraUpdate = function () {
			this._cameraNeedRefresh = true;
		};

		// 更新焦点坐标，目前仅根据大地图偏移决定
		this.updateTargetPosition = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
		};

		// 更新额外的刷新条件，即镜头未指向焦点时
		this.updateRefreshFlag = function () {
			if (this._nowOffsetX != this._targetOffsetX || this._nowOffsetY != this._targetOffsetY) {
				this._cameraNeedRefresh = true;
			}
		};

		// 判断是否禁止了弹性滚动
		this.canDirectMove = function () {
			return !core.getFlag(this.__switchName, true);
		};

		// 更新镜头坐标
		this.updateCameraPosition = function () {
			if (this._cameraNeedRefresh) {
				this._cameraNeedRefresh = false;
				var disX = this._targetOffsetX - this._nowOffsetX;
				var disY = this._targetOffsetY - this._nowOffsetY;
				if (Math.abs(disX) <= 2 && Math.abs(disY) <= 2 || this.canDirectMove()) {
					this._nowOffsetX = this._targetOffsetX;
					this._nowOffsetY = this._targetOffsetY;
				} else {
					this._nowOffsetX += disX / 10;
					this._nowOffsetY += disY / 10;
				}
				var x = -Math.floor(this._nowOffsetX);
				var y = -Math.floor(this._nowOffsetY);
				core.bigmap.canvas.forEach(function (cn) {
					core.control.setGameCanvasTranslate(cn, x, y);
				});
				core.relocateCanvas('route', core.status.automaticRoute.offsetX + x, core.status.automaticRoute.offsetY + y);
				core.setGameCanvasTranslate('hero', x + this._targetOffsetX, y + this._targetOffsetY);
			}
		};

		// 更新逻辑主体
		this.update = function () {
			this.updateTargetPosition();
			this.updateRefreshFlag();
			this.updateCameraPosition();
		};
	};

	// 其实只注释了最后一行，只能这样了
	control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 32 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		//core.setGameCanvasTranslate('hero', 0, 0);
	};

	// 复写转发
	core.drawHero = function (status, offset) {
		return core.control.drawHero(status, offset);
	};

	// 创建摄像机对象
	this.camera = new this.Camera();

	// 帧事件 更新摄像机
	this.updateCameraEx = function () {
		this.camera.update();
	};

	// 代理原本的镜头事件
	control.updateViewport = function () {
		core.plugin.camera.requestCameraUpdate();
	};

	// 更变楼层的行为追加，重置镜头
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		core.plugin.camera.resetCamera();
	};

	// 注册帧事件
	core.registerAnimationFrame('smoothCameraFlash', true, this.updateCameraEx.bind(this));
},
    "SkillTree": function () {

	// [技能图片名, x坐标, y坐标]
	// 记得在全塔属性里注册
	var images = [
		["tianfu1.png", 104, 30],
		["tianfu2.png", 224, 30],
		["tianfu3.png", 344, 30],
		["tianfu4.png", 80, 130],
		["tianfu5.png", 176, 130],
		["tianfu6.png", 272, 130],
		["tianfu7.png", 368, 130],
		["tianfu8.png", 64, 230],
		["tianfu9.png", 144, 230],
		["tianfu10.png", 224, 230],
		["tianfu11.png", 304, 230],
		["tianfu12.png", 384, 230],
	];

	// 技能之间的连线
	var edges = [];

	// 技能的初始等级
	var level = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

	// 技能的满级
	var full_level = [8, 8, 10, 14, 12, 12, 10, 10, 10, 15, 10, 10];

	// 技能的前置技能。若没有，则填-1
	// 0号技能不能有前置技能
	var fathers = [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
	var sons = [];

	// 技能的各级描述
	var description = {
		"tianfu1.png": [
			"【肾上腺素水平优化】\n当前等级：0 / 8，肾上腺素效果增加：0%\n下一级：5%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：1 / 8，肾上腺素效果增加：5%\n下一级：10%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：2 / 8，肾上腺素效果增加：10%\n下一级：15%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：3 / 8，肾上腺素效果增加：15%\n下一级：20%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：4 / 8，肾上腺素效果增加：20%\n下一级：25%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：5 / 8，肾上腺素效果增加：25%\n下一级：30%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：6 / 8，肾上腺素效果增加：30%\n下一级：35%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：7 / 8，肾上腺素效果增加：35%\n下一级：40%（满级：40%）\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
			"【肾上腺素水平优化】\n当前等级：8 / 8，肾上腺素效果增加：40%\n已强化到极限。\n强化机体对肾上腺素的利用效能，对肾上腺素受体进行调控，增强其活性。",
		],
		"tianfu2.png": [
			"【传导阻滞剂水平优化】\n当前等级：0 / 8，传导阻滞剂效果增加：0%\n下一级：5%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：1 / 8，传导阻滞剂效果增加：5%\n下一级：10%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：2 / 8，传导阻滞剂效果增加：10%\n下一级：15%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：3 / 8，传导阻滞剂效果增加：15%\n下一级：20%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：4 / 8，传导阻滞剂效果增加：20%\n下一级：25%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：5 / 8，传导阻滞剂效果增加：25%\n下一级：30%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：6 / 8，传导阻滞剂效果增加：30%\n下一级：35%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：7 / 8，传导阻滞剂效果增加：35%\n下一级：40%（满级：40%）\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
			"【传导阻滞剂水平优化】\n当前等级：8 / 8，传导阻滞剂效果增加：40%\n已强化到极限。\n强化机体对传导阻滞剂的利用效能，对神经离子通道进行调控，进一步降低痛感。",
		],
		"tianfu3.png": [
			"【超负荷激素水平优化】\n当前等级：0 / 10，超负荷激素消耗精力降低：0\n下一级：10（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：1 / 10，超负荷激素消耗精力降低：10\n下一级：20（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：2 / 10，超负荷激素消耗精力降低：20\n下一级：30（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：3 / 10，超负荷激素消耗精力降低：30\n下一级：40（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：4 / 10，超负荷激素消耗精力降低：40\n下一级：50（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：5 / 10，超负荷激素消耗精力降低：50\n下一级：60（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：6 / 10，超负荷激素消耗精力降低：60\n下一级：70（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：7 / 10，超负荷激素消耗精力降低：70\n下一级：80（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：8 / 10，超负荷激素消耗精力降低：80\n下一级：90（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：9 / 10，超负荷激素消耗精力降低：90\n下一级：100（满级：100）\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
			"【超负荷激素水平优化】\n当前等级：10 / 10，超负荷激素消耗精力降低：100\n已强化到极限。\n降低使用超负荷激素后的影响，改进生命支持元素，减少激素负荷，降低消耗精力。",
		],
		"tianfu4.png": [
			"【金属化细胞】\n当前等级：0 / 14，免伤增加：0%\n下一级：1%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：1 / 14，免伤增加：1%\n下一级：2%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：2 / 14，免伤增加：2%\n下一级：3%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：3 / 14，免伤增加：3%\n下一级：4%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：4 / 14，免伤增加：4%\n下一级：5%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：5 / 14，免伤增加：5%\n下一级：6%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：6 / 14，免伤增加：6%\n下一级：7%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：7 / 14，免伤增加：7%\n下一级：8%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：8 / 14，免伤增加：8%\n下一级：9%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：9 / 14，免伤增加：9%\n下一级：10%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：10 / 14，免伤增加：10%\n下一级：11%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：11 / 14，免伤增加：11%\n下一级：12%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：12 / 14，免伤增加：12%\n下一级：13%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：13 / 14，免伤增加：13%\n下一级：14%（满级：14%）\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
			"【金属化细胞】\n当前等级：14 / 14，免伤增加：14%\n已强化到极限。\n对表皮细胞组织进行金属化改造，允许承受更多伤害。",
		],
		"tianfu5.png": [
			"【血液兴奋】\n当前等级：0 / 12，攻击上升：0%\n下一级：1%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：1 / 12，攻击上升：1%\n下一级：2%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：2 / 12，攻击上升：2%\n下一级：3%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：3 / 12，攻击上升：3%\n下一级：4%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：4 / 12，攻击上升：4%\n下一级：5%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：5 / 12，攻击上升：5%\n下一级：6%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：6 / 12，攻击上升：6%\n下一级：7%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：7 / 12，攻击上升：7%\n下一级：8%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：8 / 12，攻击上升：8%\n下一级：9%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：9 / 12，攻击上升：9%\n下一级：10%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：10 / 12，攻击上升：10%\n下一级：11%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：11 / 12，攻击上升：11%\n下一级：12%（满级：12%）\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
			"【血液兴奋】\n当前等级：12 / 12，攻击上升：12%\n已强化到极限。\n增强血液流速，提高氧分子结合率，为机体提供更多能量，增强攻击力。",
		],
		"tianfu6.png": [
			"【神经抑制】\n当前等级：0 / 12，防御上升：0%\n下一级：1%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：1 / 12，防御上升：1%\n下一级：2%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：2 / 12，防御上升：2%\n下一级：3%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：3 / 12，防御上升：3%\n下一级：4%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：4 / 12，防御上升：4%\n下一级：5%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：5 / 12，防御上升：5%\n下一级：6%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：6 / 12，防御上升：6%\n下一级：7%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：7 / 12，防御上升：7%\n下一级：8%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：8 / 12，防御上升：8%\n下一级：9%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：9 / 12，防御上升：9%\n下一级：10%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：10 / 12，防御上升：10%\n下一级：11%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：11 / 12，防御上升：11%\n下一级：12%（满级：12%）\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
			"【神经抑制】\n当前等级：12 / 12，防御上升：12%\n已强化到极限。\n对全身关键部位神经进行抑制，减少痛感，增强防御力。",
		],
		"tianfu7.png": [
			"【生物电能源增幅电容】\n当前等级：0 / 10，护盾上升：0%\n下一级：3%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：1 / 10，护盾上升：3%\n下一级：6%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：2 / 10，护盾上升：6%\n下一级：9%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：3 / 10，护盾上升：9%\n下一级：12%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：4 / 10，护盾上升：12%\n下一级：15%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：5 / 10，护盾上升：15%\n下一级：18%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：6 / 10，护盾上升：18%\n下一级：21%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：7 / 10，护盾上升：21%\n下一级：24%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：8 / 10，护盾上升：24%\n下一级：27%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：9 / 10，护盾上升：27%\n下一级：30%（满级：30%）\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
			"【生物电能源增幅电容】\n当前等级：10 / 10，护盾上升：30%\n已强化到极限。\n生物电转化技术，配合辅助微电解单元，为护盾发生器提供强化增幅。",
		],
		"tianfu8.png": [
			"【代谢加速】\n当前等级：0 / 10，精力恢复速度增加：0点\n下一级：1点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：1 / 10，精力恢复速度增加：1点\n下一级：2点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：2 / 10，精力恢复速度增加：2点\n下一级：3点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：3 / 10，精力恢复速度增加：3点\n下一级：4点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：4 / 10，精力恢复速度增加：4点\n下一级：5点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：5 / 10，精力恢复速度增加：5点\n下一级：6点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：6 / 10，精力恢复速度增加：6点\n下一级：7点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：7 / 10，精力恢复速度增加：7点\n下一级：8点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：8 / 10，精力恢复速度增加：8点\n下一级：9点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：9 / 10，精力恢复速度增加：9点\n下一级：10点（满级：10点）\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
			"【代谢加速】\n当前等级：10 / 10，精力恢复速度增加：10点\n已强化到极限。\n加速合成血糖，快速清除有害组织代谢产物，增强新陈代谢能力，提高精力恢复速度。",
		],
		"tianfu9.png": [
			"【脑神经元强化】\n当前等级：0 / 10，疲劳抗性提升：0%\n下一级：5%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：1 / 10，疲劳抗性提升：5%\n下一级：10%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：2 / 10，疲劳抗性提升：10%\n下一级：15%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：3 / 10，疲劳抗性提升：15%\n下一级：20%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：4 / 10，疲劳抗性提升：20%\n下一级：25%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：5 / 10，疲劳抗性提升：25%\n下一级：30%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：6 / 10，疲劳抗性提升：30%\n下一级：35%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：7 / 10，疲劳抗性提升：35%\n下一级：40%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：8 / 10，疲劳抗性提升：40%\n下一级：45%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：9 / 10，疲劳抗性提升：45%\n下一级：50%（满级：50%）\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
			"【脑神经元强化】\n当前等级：10 / 10，疲劳抗性提升：50%\n已强化到极限。\n强化中枢神经系统，提高战士疲劳抗性，降低与疲劳属性怪物战斗后的精力扣除值。",
		],
		"tianfu10.png": [
			"【能量转移】\n当前等级：0 / 15，战后恢复敌人血量的0%的生命值\n下一级：1%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：1 / 15，战后恢复敌人血量的1%的生命值\n下一级：2%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：2 / 15，战后恢复敌人血量的2%的生命值\n下一级：3%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：3 / 15，战后恢复敌人血量的3%的生命值\n下一级：4%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：4 / 15，战后恢复敌人血量的4%的生命值\n下一级：5%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：5 / 15，战后恢复敌人血量的5%的生命值\n下一级：6%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：6 / 15，战后恢复敌人血量的6%的生命值\n下一级：7%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：7 / 15，战后恢复敌人血量的7%的生命值\n下一级：8%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：8 / 15，战后恢复敌人血量的8%的生命值\n下一级：9%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：9 / 15，战后恢复敌人血量的9%的生命值\n下一级：10%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：10 / 15，战后恢复敌人血量的10%的生命值\n下一级：11%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：11 / 15，战后恢复敌人血量的11%的生命值\n下一级：12%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：12 / 15，战后恢复敌人血量的12%的生命值\n下一级：13%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：13 / 15，战后恢复敌人血量的13%的生命值\n下一级：14%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：14 / 15，战后恢复敌人血量的14%的生命值\n下一级：15%（满级：15%）\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
			"【能量转移】\n当前等级：15 / 15，战后恢复敌人血量的15%的生命值\n已强化到极限。\n坏死有机产物提炼单元，允许从死亡有机体中提取余量生物能源，转化为生命元素。",
		],
		"tianfu11.png": [
			"【毒素辅助清除抗体】\n当前等级：0 / 10，战后毒素清除层数增加等级*0层\n下一级：1层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：1 / 10，战后毒素清除层数增加等级*1层\n下一级：2层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：2 / 10，战后毒素清除层数增加等级*2层\n下一级：3层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：3 / 10，战后毒素清除层数增加等级*3层\n下一级：4层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：4 / 10，战后毒素清除层数增加等级*4层\n下一级：5层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：5 / 10，战后毒素清除层数增加等级*5层\n下一级：6层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：6 / 10，战后毒素清除层数增加等级*6层\n下一级：7层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：7 / 10，战后毒素清除层数增加等级*7层\n下一级：8层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：8 / 10，战后毒素清除层数增加等级*8层\n下一级：9层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：9 / 10，战后毒素清除层数增加等级*9层\n下一级：10层（满级：10层）\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
			"【毒素辅助清除抗体】\n当前等级：10 / 10，战后毒素清除层数增加等级*10层\n已强化到极限。\n辅助合成大分子毒素抑制蛋白，增强毒素清除能力。",
		],
		"tianfu12.png": [
			"【过载保护】\n当前等级：0 / 10，纳米机器人过载影响降低：0%\n下一级：8%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：1 / 10，纳米机器人过载影响降低：8%\n下一级：16%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：2 / 10，纳米机器人过载影响降低：16%\n下一级：24%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：3 / 10，纳米机器人过载影响降低：24%\n下一级：32%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：4 / 10，纳米机器人过载影响降低：32%\n下一级：40%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：5 / 10，纳米机器人过载影响降低：40%\n下一级：48%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：6 / 10，纳米机器人过载影响降低：48%\n下一级：56%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：7 / 10，纳米机器人过载影响降低：56%\n下一级：64%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：8 / 10，纳米机器人过载影响降低：64%\n下一级：72%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：9 / 10，纳米机器人过载影响降低：72%\n下一级：80%（满级：80%）\n优化过载进程，减轻过载带来的机体损伤影响。",
			"【过载保护】\n当前等级：10 / 10，纳米机器人过载影响降低：80%\n已强化到极限。\n优化过载进程，减轻过载带来的机体损伤影响。",
		],
	};
	var current, old_current;
	var content = "";

	// 此处假定图片的长宽均为32. 如果不是，请修改此处的32，以及下文的所有32和16（此为长/宽的一半）。
	this.inRect = function (px, py, rx, ry) {
		return (px >= rx) && (px <= rx + 32) && (py >= ry) && (py <= ry + 32);
	};

	this._drawEdge = function (x1, y1, x2, y2) {
		if (y1 < y2)
			core.drawLine("uievent", x1, y1 + 32, x2, y2, 'white');
		else
			core.drawLine("uievent", x1, y1, x2, y2 + 32, 'white');
	};

	this.tryUpdate = function (pos, gift) {
		var father = fathers[pos];
		if (!gift && core.getFlag("skillpoint", 0) <= 0) {
			core.playSound('mouse_error.mp3');
			core.insertAction({ "type": "tip", "text": "进化点不足！" });
			return;
		}
		if (father != -1 && level[father] != full_level[father])
			return;

		if (pos == 0) {
			level[pos] = core.getFlag("tianfu1", 0);
		}
		if (pos == 1) {
			level[pos] = core.getFlag("tianfu2", 0);
		}
		if (pos == 2) {
			level[pos] = core.getFlag("tianfu3", 0);
		}
		if (pos == 3) {
			level[pos] = core.getFlag("tianfu4", 0);
		}
		if (pos == 4) {
			level[pos] = core.getFlag("tianfu5", 0);
		}
		if (pos == 5) {
			level[pos] = core.getFlag("tianfu6", 0);
		}
		if (pos == 6) {
			level[pos] = core.getFlag("tianfu7", 0);
		}
		if (pos == 7) {
			level[pos] = core.getFlag("tianfu8", 0);
		}
		if (pos == 8) {
			level[pos] = core.getFlag("tianfu9", 0);
		}
		if (pos == 9) {
			level[pos] = core.getFlag("tianfu10", 0);
		}
		if (pos == 10) {
			level[pos] = core.getFlag("tianfu11", 0);
		}
		if (pos == 11) {
			level[pos] = core.getFlag("tianfu12", 0);
		}


		if (level[pos] == full_level[pos]) {
			core.playSound('mouse_error.mp3');
			core.insertAction({ "type": "tip", "text": "已升至最高等级，不可再升级！" });
			return;
		}


		level[pos] += 1;
		core.addFlag("skillpoint", gift ? 0 : -1);
		core.playSound('tianfudian.mp3');
		core.insertAction({ "type": "tip", "text": "升级成功！" });

		if (pos == 0) {
			core.addFlag("tianfu1", 1);
			level[pos] = core.getFlag("tianfu1", 0);
		}
		if (pos == 1) {
			core.addFlag("tianfu2", 1);
			level[pos] = core.getFlag("tianfu2", 0);
		}
		if (pos == 2) {
			core.addFlag("tianfu3", 1);
			level[pos] = core.getFlag("tianfu3", 0);
		}
		if (pos == 3) {
			core.addFlag("tianfu4", 1);
			level[pos] = core.getFlag("tianfu4", 0);
		}
		if (pos == 4) {
			core.addFlag("tianfu5", 1);
			level[pos] = core.getFlag("tianfu5", 0);
		}
		if (pos == 5) {
			core.addFlag("tianfu6", 1);
			level[pos] = core.getFlag("tianfu6", 0);
		}
		if (pos == 6) {
			core.addFlag("tianfu7", 1);
			level[pos] = core.getFlag("tianfu7", 0);
		}
		if (pos == 7) {
			core.addFlag("tianfu8", 1);
			level[pos] = core.getFlag("tianfu8", 0);
		}
		if (pos == 8) {
			core.addFlag("tianfu9", 1);
			level[pos] = core.getFlag("tianfu9", 0);
		}
		if (pos == 9) {
			core.addFlag("tianfu10", 1);
			level[pos] = core.getFlag("tianfu10", 0);
		}
		if (pos == 10) {
			core.addFlag("tianfu11", 1);
			level[pos] = core.getFlag("tianfu11", 0);
		}
		if (pos == 11) {
			core.addFlag("tianfu12", 1);
			level[pos] = core.getFlag("tianfu12", 0);
		}

		if (pos == 0)
			content = description[images[pos][0]][flags.tianfu1];
		if (pos == 1)
			content = description[images[pos][0]][flags.tianfu2];
		if (pos == 2)
			content = description[images[pos][0]][flags.tianfu3];
		if (pos == 3)
			content = description[images[pos][0]][flags.tianfu4];
		if (pos == 4)
			content = description[images[pos][0]][flags.tianfu5];
		if (pos == 5)
			content = description[images[pos][0]][flags.tianfu6];
		if (pos == 6)
			content = description[images[pos][0]][flags.tianfu7];
		if (pos == 7)
			content = description[images[pos][0]][flags.tianfu8];
		if (pos == 8)
			content = description[images[pos][0]][flags.tianfu9];
		if (pos == 9)
			content = description[images[pos][0]][flags.tianfu10];
		if (pos == 10)
			content = description[images[pos][0]][flags.tianfu11];
		if (pos == 11)
			content = description[images[pos][0]][flags.tianfu12];
		core.updateStatusBar();

	};

	this.revealLevel = function (pos) {
		return level[pos];
	};

	this.drawSkillTree = function () {
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawBackground({ background: [0, 0, 0, 0.85], x: 0, y: 0, width: 480, height: 480 });
		for (var i in images) {
			core.drawImage("uievent", images[i][0], images[i][1], images[i][2]);
			if (i == current) {
				var x = images[i][1],
					y = images[i][2];
				core.drawLine("uievent", x, y, x + 32, y, 'red');
				core.drawLine("uievent", x, y, x, y + 32, 'red');
				core.drawLine("uievent", x + 32, y, x + 32, y + 32, 'red');
				core.drawLine("uievent", x, y + 32, x + 32, y + 32, 'red');
			}
		}
		for (var i in edges)
			this._drawEdge(images[edges[i][0]][1] + 16, images[edges[i][0]][2], images[edges[i][1]][1] + 16, images[edges[i][1]][2]);
		core.ui._uievent_drawTextContent({ text: "进化点剩余：" + core.getFlag("skillpoint", 0), left: 10, top: 285 });
		core.ui._uievent_drawTextContent({ text: "天赋效果说明：", left: 10, top: 305 });
		core.ui._uievent_drawTextContent({ text: content, left: 10, top: 325, maxWidth: 390 });
		core.ui._uievent_drawTextContent({ text: "离开", left: 400, top: 420, bold: true, fontSize: 24 });
	};

	this._clickedSkill = function (px, py) {
		for (var i in images)
			if (this.inRect(px, py, images[i][1], images[i][2])) {
				old_current = current;
				current = i;
				if (i == 0)
					content = description[images[i][0]][flags.tianfu1];
				if (i == 1)
					content = description[images[i][0]][flags.tianfu2];
				if (i == 2)
					content = description[images[i][0]][flags.tianfu3];
				if (i == 3)
					content = description[images[i][0]][flags.tianfu4];
				if (i == 4)
					content = description[images[i][0]][flags.tianfu5];
				if (i == 5)
					content = description[images[i][0]][flags.tianfu6];
				if (i == 6)
					content = description[images[i][0]][flags.tianfu7];
				if (i == 7)
					content = description[images[i][0]][flags.tianfu8];
				if (i == 8)
					content = description[images[i][0]][flags.tianfu9];
				if (i == 9)
					content = description[images[i][0]][flags.tianfu10];
				if (i == 10)
					content = description[images[i][0]][flags.tianfu11];
				if (i == 11)
					content = description[images[i][0]][flags.tianfu12];
				// content = description[images[i][0]][level[i]];
				if (old_current == current)
					this.tryUpdate(i, false);
				core.playSound('mouse_click.mp3');
			}
		if (px >= 400 && px <= 450 && py >= 420 && py <= 460) // 离开
		{
			core.playSound('system_offline.mp3');
			return core.insertAction({ "type": "break" });
		}
	};

	// 此处默认按W键退出技能树，可以修改下文的87为想要的值（或者删除）。
	this._keySkill = function (key) {
		var fa = fathers[current];
		var i = 0;
		switch (key) {
		case 87:
		case 27: //esc/w
			core.playSound('system_offline.mp3');
			core.insertAction({ "type": "break" });
			break;
		case 38: //up
			core.playSound('mouse_click.mp3');
			if (fathers[current] != -1) {
				old_current = current;
				current = fathers[current];
			}
			if (current == 0)
				content = description[images[current][0]][flags.tianfu1];
			if (current == 1)
				content = description[images[current][0]][flags.tianfu2];
			if (current == 2)
				content = description[images[current][0]][flags.tianfu3];
			if (current == 3)
				content = description[images[current][0]][flags.tianfu4];
			if (current == 4)
				content = description[images[current][0]][flags.tianfu5];
			if (current == 5)
				content = description[images[current][0]][flags.tianfu6];
			if (current == 6)
				content = description[images[current][0]][flags.tianfu7];
			if (current == 7)
				content = description[images[current][0]][flags.tianfu8];
			if (current == 8)
				content = description[images[current][0]][flags.tianfu9];
			if (current == 9)
				content = description[images[current][0]][flags.tianfu10];
			if (current == 10)
				content = description[images[current][0]][flags.tianfu11];
			if (current == 11)
				content = description[images[current][0]][flags.tianfu12];
			//content = description[images[current][0]][level[current]];
			break;
		case 40: //down
			core.playSound('mouse_click.mp3');
			if (sons[current] && sons[current][0] != -1) {
				old_current = current;
				current = sons[current][0];
			}
			if (current == 0)
				content = description[images[current][0]][flags.tianfu1];
			if (current == 1)
				content = description[images[current][0]][flags.tianfu2];
			if (current == 2)
				content = description[images[current][0]][flags.tianfu3];
			if (current == 3)
				content = description[images[current][0]][flags.tianfu4];
			if (current == 4)
				content = description[images[current][0]][flags.tianfu5];
			if (current == 5)
				content = description[images[current][0]][flags.tianfu6];
			if (current == 6)
				content = description[images[current][0]][flags.tianfu7];
			if (current == 7)
				content = description[images[current][0]][flags.tianfu8];
			if (current == 8)
				content = description[images[current][0]][flags.tianfu9];
			if (current == 9)
				content = description[images[current][0]][flags.tianfu10];
			if (current == 10)
				content = description[images[current][0]][flags.tianfu11];
			if (current == 11)
				content = description[images[current][0]][flags.tianfu12];
			//content = description[images[current][0]][level[current]];
			break;
		case 37: //left
			core.playSound('mouse_click.mp3');
			for (; i < sons[fa].length; i++)
				if (sons[fa][i] == current)
					break;
			if (sons[fa][i - 1]) {
				old_current = current;
				current = sons[fa][i - 1];
			}
			if (current == 0)
				content = description[images[current][0]][flags.tianfu1];
			if (current == 1)
				content = description[images[current][0]][flags.tianfu2];
			if (current == 2)
				content = description[images[current][0]][flags.tianfu3];
			if (current == 3)
				content = description[images[current][0]][flags.tianfu4];
			if (current == 4)
				content = description[images[current][0]][flags.tianfu5];
			if (current == 5)
				content = description[images[current][0]][flags.tianfu6];
			if (current == 6)
				content = description[images[current][0]][flags.tianfu7];
			if (current == 7)
				content = description[images[current][0]][flags.tianfu8];
			if (current == 8)
				content = description[images[current][0]][flags.tianfu9];
			if (current == 9)
				content = description[images[current][0]][flags.tianfu10];
			if (current == 10)
				content = description[images[current][0]][flags.tianfu11];
			if (current == 11)
				content = description[images[current][0]][flags.tianfu12];
			//content = description[images[current][0]][level[current]];
			break;
		case 39: // right
			core.playSound('mouse_click.mp3');
			for (; i < sons[fa].length; i++)
				if (sons[fa][i] == current)
					break;
			if (sons[fa][i + 1]) {
				old_current = current;
				current = sons[fa][i + 1];
			}
			if (current == 0)
				content = description[images[current][0]][flags.tianfu1];
			if (current == 1)
				content = description[images[current][0]][flags.tianfu2];
			if (current == 2)
				content = description[images[current][0]][flags.tianfu3];
			if (current == 3)
				content = description[images[current][0]][flags.tianfu4];
			if (current == 4)
				content = description[images[current][0]][flags.tianfu5];
			if (current == 5)
				content = description[images[current][0]][flags.tianfu6];
			if (current == 6)
				content = description[images[current][0]][flags.tianfu7];
			if (current == 7)
				content = description[images[current][0]][flags.tianfu8];
			if (current == 8)
				content = description[images[current][0]][flags.tianfu9];
			if (current == 9)
				content = description[images[current][0]][flags.tianfu10];
			if (current == 10)
				content = description[images[current][0]][flags.tianfu11];
			if (current == 11)
				content = description[images[current][0]][flags.tianfu12];
			//content = description[images[current][0]][level[current]];
			break;
		case 13:
		case 32: //enter/space
			this.tryUpdate(current);
		}
	};

	this.activateSkill = function () {
		if (flags.type == 0)
			this._keySkill(flags.keycode);
		else
			this._clickedSkill(flags.px, flags.py);
	};

	this.openSkillTree = function (skillTreeId) {
		core.playSound('system_online.mp3');
		for (var i in fathers) {
			var fa = fathers[i];
			if (!sons[fa])
				sons[fa] = [];
			sons[fa].push(i);
		}
		current = 0;
		old_current = -1;
		content = description[images[current][0]][flags.tianfu1]; //此处有魔改，改成了根据变量tianfu1来显示
		//content = description[images[current][0]][level[current]];
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawSkillTree(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.activateSkill(); }" }
				]
			},
			{
				"type": "function",
				"function": "function () { " +
					"core.deleteCanvas('uievent');" +
					"core.clearUI(); " +
					"core.clearMap('uievent');" +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}"
			}
		]);
	};

}
}